// priority: 100
onEvent('entity.loot_tables', event => {
    //Terracubes are a little bit underwhelming compare to other ways to generate materials. Let's fix that.
    event.modifyEntity('tconstruct:terracube', table => {
        table.clearPools();
        table.addPool(pool => {
            pool.rolls = 1
            pool.addItem('minecraft:clay_ball')
        })
    })
})

onEvent('recipes', (event) => {
    const castingBasin = (fluidTag, amount, outputItem, coolingTime) => {
        event.custom({
            'type': 'tconstruct:casting_basin',
            'fluid': {
                'tag': fluidTag,
                'amount': amount
            },
            'result': {
                'item': outputItem
            },
            'cooling_time': coolingTime
        });
    }

    castingBasin('forge:molten_nickel', 810, 'thermal:nickel_block', 194);
    castingBasin('forge:molten_tin', 810, 'thermal:tin_block', 117)
    castingBasin('forge:molten_lead', 810, 'thermal:lead_block', 130)
    castingBasin('forge:molten_silver', 810, 'thermal:silver_block', 179)
    castingBasin('forge:molten_bronze', 810, 'thermal:bronze_block', 171)
    castingBasin('forge:molten_constantan', 810, 'thermal:constantan_block', 192)
    castingBasin('forge:molten_electrum', 810, 'thermal:electrum_block', 177)
    castingBasin('forge:molten_uranium', 810, 'mekanism:block_uranium', 183)
    castingBasin('forge:molten_steel', 810, 'mekanism:block_steel', 194)

    //Cobalt smelting (I know it's normally disabled, but it's unintuitive with the rest of the pack...)
    event.recipes.minecraft.smelting('tconstruct:cobalt_ingot', '#forge:raw_materials/cobalt').xp(1.5);
    event.recipes.minecraft.smelting('tconstruct:cobalt_ingot', '#forge:ores/cobalt').xp(1.5);
});

